/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.content.thirst;

import de.teamlapen.vampirism.util.Helper;
import dev.ghen.thirst.api.ThirstHelper;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.damagesource.ModDamageSource;
import dev.ghen.thirst.foundation.config.CommonConfig;
import dev.ghen.thirst.foundation.network.ThirstModPacketHandler;
import dev.ghen.thirst.foundation.network.message.PlayerThirstSyncMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class PlayerThirst
implements IThirst {
    public static boolean checkTombstoneEffects = false;
    public static boolean checkFDEffects = false;
    public static boolean checkVampirismEffects = false;
    public static boolean checkLetsDoBakeryEffects = false;
    int thirst = 20;
    int quenched = 5;
    float exhaustion = 0.0f;
    int damageTimer = 0;
    int syncTimer = 0;
    float prevTickExhaustion = 0.0f;
    boolean justHealed = false;
    Vec3 lastPos = Vec3.f_82478_;
    private static final float exhaustionMultiplier = 0.175f;

    public Vec3 getLastPos() {
        return this.lastPos;
    }

    @Override
    public int getThirst() {
        return this.thirst;
    }

    @Override
    public void setThirst(int value) {
        this.thirst = value;
    }

    @Override
    public int getQuenched() {
        return this.quenched;
    }

    @Override
    public void setQuenched(int value) {
        this.quenched = value;
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public void setExhaustion(float value) {
        this.exhaustion = value;
    }

    @Override
    public void drink(Player player, int thirst, int quenched) {
        this.thirst = Math.min(this.thirst + thirst, 20);
        this.quenched = Math.min(this.quenched + quenched, this.thirst);
    }

    @Override
    public void tick(Player player) {
        boolean isStuffed;
        Difficulty difficulty = player.f_19853_.m_46791_();
        if (player.m_150110_().f_35934_ || player.m_21023_(MobEffects.f_19607_)) {
            return;
        }
        if (checkTombstoneEffects && player.m_21023_(ovh.corail.tombstone.registry.ModEffects.ghostly_shape)) {
            return;
        }
        if (checkVampirismEffects && Helper.isVampire((Player)player)) {
            return;
        }
        boolean isNourished = checkFDEffects && player.m_21023_((MobEffect)ModEffects.NOURISHMENT.get());
        boolean bl = isStuffed = checkLetsDoBakeryEffects && player.m_21220_().stream().anyMatch(e -> e.m_19576_().contains("stuffed"));
        if (!isNourished && !isStuffed) {
            this.updateExhaustion(player);
        }
        if (this.exhaustion > 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.quenched > 0) {
                --this.quenched;
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.thirst = Math.max(this.thirst - 1, 0);
            }
        }
        ++this.syncTimer;
        if (this.syncTimer > 10 && !player.m_9236_().m_5776_()) {
            this.updateThirstData(player);
            this.syncTimer = 0;
        }
        if (this.thirst <= 0) {
            ++this.damageTimer;
            if (this.damageTimer >= 40) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 0.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(ModDamageSource.DEHYDRATE, 1.0f);
                }
                this.damageTimer = 0;
            }
        }
    }

    void updateExhaustion(Player player) {
        float hungerExhaustion = player.m_36324_().m_150380_();
        float normalizedHungerExhaustion = hungerExhaustion < this.prevTickExhaustion ? hungerExhaustion + 4.0f : hungerExhaustion;
        float deltaExhaustion = normalizedHungerExhaustion - this.prevTickExhaustion;
        this.addExhaustion(player, deltaExhaustion);
        this.prevTickExhaustion = hungerExhaustion;
    }

    @Override
    public void updateThirstData(Player player) {
        ThirstModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerThirstSyncMessage(this.thirst, this.quenched, this.exhaustion));
    }

    @Override
    public void setJustHealed() {
        this.justHealed = true;
    }

    @Override
    public void copy(IThirst cap) {
        this.thirst = cap.getThirst();
        this.quenched = cap.getQuenched();
        this.exhaustion = cap.getExhaustion();
    }

    @Override
    public void addExhaustion(Player player, float amount) {
        if (!((Boolean)CommonConfig.HEALTH_REGEN_DEPLETES_HYDRATION.get()).booleanValue() && this.justHealed) {
            amount = 0.0f;
        }
        this.exhaustion = !((Boolean)CommonConfig.HEALTH_REGEN_DEHYDRATION_IS_BIOME_DEPENDENT.get()).booleanValue() && this.justHealed ? (this.exhaustion += amount) : (this.exhaustion += amount * ThirstHelper.getExhaustionBiomeModifier(player) * ThirstHelper.getExhaustionFireProtModifier(player));
        if (this.justHealed) {
            this.justHealed = false;
        }
        this.updateThirstData(player);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("thirst", this.thirst);
        nbt.m_128405_("quenched", this.quenched);
        nbt.m_128350_("exhaustion", this.exhaustion);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.thirst = nbt.m_128451_("thirst");
        this.quenched = nbt.m_128451_("quenched");
        this.exhaustion = nbt.m_128457_("exhaustion");
    }
}

